#define MAXWORLDSIZE 256
#define MAX_ACTIVE_SHOTS 128

struct TILE{ //the world tile data textures bumpmaps und x,y cord
	int x[4],y[4],z[4];
	GLuint texture;
	};


TILE data[MAXWORLDSIZE][MAXWORLDSIZE];

#include <stdio.h>
class WORLD{
public:
	int i,j;
	int sizex,sizey;


void LoadTextureMap(char *filename)
	{
	FILE *fptr;
	if((fptr=fopen(filename,"rb"))==NULL)
		{
		printf("couldn't load texturemapdata %s into memory reason:file don't exist or no memory left!",filename);
		}
	sizex=fgetc(fptr);
	sizey=fgetc(fptr);
	for(i=0;i<sizex;i++){
	for(j=0;j<sizey;j++){				
		data[i][j].texture=fgetc(fptr);	
		}}
	fclose(fptr);	
	}//end of LoadTextureMap

void LoadBumpMap(char *filename)
	{
	FILE *fptr;
	char temp;
	if(!(fptr=fopen(filename,"rb")))
		{
		printf("couldn't load bumpmap datafile %s into memory reason:file don't exist or no memory left!",filename);
		}
	sizex=fgetc(fptr);
	sizey=fgetc(fptr);
	for(i=0;i<sizex;i++){
	for(j=0;j<sizey;j++){				
		data[i][j].x[0]=i;	
		data[i][j].y[0]=j;
		data[i][j].x[1]=(i+1);
		data[i][j].y[1]=j;
		data[i][j].x[2]=(i+1);
		data[i][j].y[2]=(j+1);
		data[i][j].x[3]=i;
		data[i][j].y[3]=(j+1);
			if(i>0&&j>0){
				data[i][j].z[0]=data[i-1][j-1].z[2];
				data[i][j].z[1]=data[i][j-1].z[2];
				data[i][j].z[2]=fgetc(fptr);
				data[i][j].z[3]=data[i-1][j].z[2];
			}
			else
			{
			temp=fgetc(fptr);
				data[i][j].z[0]=0;
				data[i][j].z[1]=0;
				data[i][j].z[2]=0;
				data[i][j].z[3]=0;
			}
		}}
	fclose(fptr);	
	}//end of LoadMapTextures
};//end of class WORLD


//<-********->
 
class PLAYER{

#define SEEDISTANCE 25
struct SHOT{
	int x,y,z;
	int i;
	int xok,yok,zok;
	int active;
	int dur;
	};

public:
	int i,jmax,imax,j,jstart,istart;
	int heading,heading2;
	int x,y,z;
	int health;
	int socket;
	float xangle,yangle;
	SHOT shots[MAX_ACTIVE_SHOTS];

void shot(){

	for(i=0;i<MAX_ACTIVE_SHOTS;i++)
		{
		if(shots[i].active==FALSE){
			shots[i].x=x;
			shots[i].y=y;
			shots[i].z=z;
			//shots[i].xok=
			//shots[i].yok=
			//shots[i].zok=	
			shots[i].active=TRUE;
			i=MAX_ACTIVE_SHOTS;
			}
		}
}
void camera_follow(WORLD map){
	glRotatef(heading2, 1.0f , 0.0f , 0.0f);	
	GLfloat sceneroty = 360.0f - heading;	
	glRotatef(sceneroty, 0.0f , 1.0f , 0.0f);
	glTranslatef(-x, -y, -z);

	i=(int)(x)-SEEDISTANCE;
	if(i<0) i=0;
	if(i>=map.sizex) i=map.sizex-1;

	imax=(int)(x)+SEEDISTANCE;
	if(imax<0) imax=0;
	if(i>=map.sizex) imax=map.sizex-1;

	jstart=(int)(z)-SEEDISTANCE;
	if(jstart<0) jstart=0;
	if(jstart>=map.sizey) jstart=map.sizey-1;

	jmax=(int)(z)+SEEDISTANCE;
	if(jmax<0) jmax=0;
	if(jmax>=map.sizey) jmax=map.sizey-1;


	for(i=i;i<imax;i++){	
	for(j=jstart;j<jmax;j++){
//	glBindTexture(GL_TEXTURE_2D, worldtextures[data[i][j].texture]);	
	glBegin(GL_TRIANGLES); //drawing WORLD MUST BE DONE WITH TRIANGLES, IT WILL NOT WORK OTHERWIZZZE!	
		glTexCoord2f(0.0f, 0.0f);	glVertex3f(data[i][j].x[0],data[i][j].z[0],data[i][j].y[0]);
		glTexCoord2f(1.0f, 0.0f);	glVertex3f(data[i][j].x[1],data[i][j].z[1],data[i][j].y[1]);
		glTexCoord2f(1.0f, 1.0f);	glVertex3f(data[i][j].x[2],data[i][j].z[2],data[i][j].y[2]);

		glTexCoord2f(0.0f, 0.0f);	glVertex3f(data[i][j].x[0],data[i][j].z[0],data[i][j].y[0]);
		glTexCoord2f(1.0f, 1.0f);	glVertex3f(data[i][j].x[2],data[i][j].z[2],data[i][j].y[2]);
		glTexCoord2f(0.0f, 1.0f);	glVertex3f(data[i][j].x[3],data[i][j].z[3],data[i][j].y[3]);
	glEnd();
	}}
}
private:
};//end of class player

class TEXTURE{
public:

GLuint TempTexture;

	AUX_RGBImageRec *LoadBMP(char *Filename)
	{
	FILE *File=NULL;
	if (!Filename){return NULL;}
	File=fopen(Filename,"r");
	if (File){fclose(File);return auxDIBImageLoad(Filename);}
	return NULL;
	}

	GLuint LoadTexture(char *TexFilename)
	{

	AUX_RGBImageRec *TextureImage[1];					// Create Storage Space For The Texture
	memset(TextureImage,0,sizeof(void *)*1);           	// Set The Pointer To NULL
	if(TextureImage[0]=LoadBMP(TexFilename)){

	glGenTextures(1,&TempTexture);
		
		glBindTexture(GL_TEXTURE_2D, TempTexture);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST); 
		gluBuild2DMipmaps(GL_TEXTURE_2D, 3, TextureImage[0]->sizeX, TextureImage[0]->sizeY, GL_RGB, GL_UNSIGNED_BYTE, TextureImage[0]->data); 
	if (TextureImage[0])								
	{
		if (TextureImage[0]->data)						
		{
			free(TextureImage[0]->data);				
		}
		free(TextureImage[0]);
	return (TempTexture);
	}}
	else{return(1);}	

return (TempTexture);
}
void UseTexture(GLuint texture,bool blend,bool light)
	{
glDepthFunc(GL_LEQUAL);//tror den hr r bra,.
//glDepthFunc(GL_LESS);
glEnable(GL_DEPTH_TEST);
if(blend==FALSE) glDisable(GL_BLEND);
if(light==FALSE)glDisable(GL_LIGHTING);	
if(blend==TRUE){
		glDisable(GL_DEPTH_TEST);
		glColor4f(1.0f,1.0f,1.0f,0.5f);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		glEnable(GL_BLEND);}
	if(light==TRUE)glEnable(GL_LIGHTING);
	glBindTexture(GL_TEXTURE_2D, texture);
	}
void UseTextureBlend(GLuint texture,bool blend,bool light,float blendval)
	{
glDepthFunc(GL_LEQUAL);//tror den hr r bra,.
//glDepthFunc(GL_LESS);
glEnable(GL_DEPTH_TEST);
if(blend==FALSE) glDisable(GL_BLEND);
if(light==FALSE)glDisable(GL_LIGHTING);	
if(blend==TRUE){
		glDisable(GL_DEPTH_TEST);
		glColor4f(1.0f,1.0f,1.0f,blendval);
		//glBlendFunc(GL_SRC_ALPHA,GL_ONE);//GL_SRC_ALPHA,GL_ONE);

		glBlendFunc(GL_SRC_COLOR,GL_ONE);
		glEnable(GL_BLEND);}
	if(light==TRUE)glEnable(GL_LIGHTING);
	glBindTexture(GL_TEXTURE_2D, texture);
	}

};//end of textures class.

